/*
 * Decompiled with CFR 0.152.
 */
package src;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class wumppkt {
    public static final short BUMPPROTO = 1;
    public static final short HUMPPROTO = 2;
    public static final short CHUMPPROTO = 3;
    public static final short REQop = 1;
    public static final short DATAop = 2;
    public static final short ACKop = 3;
    public static final short ERRORop = 4;
    public static final short HANDOFFop = 5;
    public static final short SERVERPORT = 4715;
    public static final int INITTIMEOUT = 5000;
    public static final int SHORTSIZE = 2;
    public static final int INTSIZE = 4;
    public static final int BASESIZE = 2;
    public static final int MAXDATASIZE = 512;
    public static final int DHEADERSIZE = 8;
    public static final int MAXSIZE = 520;
    public static final int EBADPORT = 1;
    public static final int EBADPROTO = 2;
    public static final int EBADOPCODE = 3;
    public static final int ENOFILE = 4;
    public static final int ENOPERM = 5;

    static int proto(byte[] buf) {
        return buf[0];
    }

    static int opcode(byte[] buf) {
        return buf[1];
    }

    public static void w_assert(boolean cond, String s) {
        if (cond) {
            return;
        }
        System.err.println("assertion failed: " + s);
        System.exit(1);
    }

    public class BASE {
        private byte _proto;
        private byte _opcode;

        public BASE(int proto, int opcode) {
            this._proto = (byte)proto;
            this._opcode = (byte)opcode;
        }

        public BASE(byte[] buf) {
        }

        public BASE() {
        }

        public byte[] write() {
            return null;
        }

        public int size() {
            return 2;
        }

        public int proto() {
            return this._proto;
        }

        public int opcode() {
            return this._opcode;
        }
    }

    public class REQ
    extends BASE {
        private short _winsize;
        private String _filename;

        public REQ(int proto, int winsize, String filename) {
            super(proto, 1);
            this._winsize = (short)winsize;
            this._filename = filename;
        }

        public REQ(int winsize, String filename) {
            this(1, winsize, filename);
        }

        public REQ(byte[] buf) {
        }

        public byte[] write() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.size());
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                dos.writeByte(super.proto());
                dos.writeByte(super.opcode());
                dos.writeShort(this._winsize);
                dos.writeBytes(this._filename);
                dos.writeByte(0);
                return baos.toByteArray();
            }
            catch (IOException ioe) {
                System.err.println("BASE packet output conversion failed");
                return null;
            }
        }

        public int size() {
            return super.size() + 2 + this._filename.length() + 1;
        }

        public String filename() {
            return this._filename;
        }
    }

    public class ACK
    extends BASE {
        private int _blocknum;

        public ACK(int blocknum) {
            this(1, blocknum);
        }

        public ACK(short proto, int blocknum) {
            super(proto, 3);
            this._blocknum = blocknum;
        }

        public int blocknum() {
            return this._blocknum;
        }

        public void setblock(int blocknum) {
            this._blocknum = blocknum;
        }

        public byte[] write() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.size());
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                dos.writeByte(super.proto());
                dos.writeByte(super.opcode());
                dos.writeShort(0);
                dos.writeInt(this._blocknum);
                return baos.toByteArray();
            }
            catch (IOException ioe) {
                System.err.println("ACK packet output conversion failed");
                return null;
            }
        }

        public int size() {
            return super.size() + 2 + 4;
        }

        public ACK(byte[] buf) {
        }
    }

    public class DATA
    extends BASE {
        private int _blocknum;
        private byte[] _data;

        public DATA(int proto, int blocknum, byte[] data) {
            super(proto, 2);
            this._blocknum = blocknum;
            this._data = data;
        }

        public DATA(int proto, int blocknum, byte[] data, int len) {
            super(proto, 2);
            this._blocknum = blocknum;
            this._data = data;
        }

        public DATA(byte[] buf, int bufsize) {
            this(1, buf, bufsize);
        }

        public DATA(int proto, byte[] buf, int bufsize) {
            super(proto, 2);
            ByteArrayInputStream bais = new ByteArrayInputStream(buf, 0, bufsize);
            DataInputStream dis = new DataInputStream(bais);
            try {
                byte p = dis.readByte();
                wumppkt.w_assert(p == proto, "Expecting proto " + proto + ", got " + p);
                byte o = dis.readByte();
                wumppkt.w_assert(o == 2, "Expecting opcode=DATA, got " + o);
                short pad = dis.readShort();
                this._blocknum = dis.readInt();
                this._data = new byte[dis.available()];
                dis.read(this._data);
            }
            catch (IOException ioe) {
                System.err.println("DATA packet conversion failed");
                return;
            }
        }

        public DATA(int proto) {
            super(proto, 2);
            this._blocknum = 0;
            this._data = new byte[512];
        }

        public DATA() {
            this(1);
        }

        public int blocknum() {
            return this._blocknum;
        }

        public byte[] data() {
            return this._data;
        }

        public byte[] write() {
            return null;
        }

        public int size() {
            return super.size() + 2 + 4 + this._data.length;
        }
    }

    public class ERROR
    extends BASE {
        private short _errcode;

        public ERROR(short proto, short errcode) {
            super(proto, 4);
        }

        public short errcode() {
            return this._errcode;
        }

        public byte[] write() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.size());
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                dos.writeByte(super.proto());
                dos.writeByte(super.opcode());
                dos.writeShort(this._errcode);
                return baos.toByteArray();
            }
            catch (IOException ioe) {
                System.err.println("ERROR packet output conversion failed");
                return null;
            }
        }

        public ERROR(byte[] buf) {
            this(1, buf);
        }

        public ERROR(int proto, byte[] buf) {
            super(proto, 2);
            int opcode = wumppkt.opcode(buf);
            wumppkt.w_assert(opcode == 4, "Expecting opcode=ERROR, got " + opcode);
            wumppkt.w_assert(proto == wumppkt.proto(buf), "Expecting proto=" + proto);
            wumppkt.w_assert(buf.length >= 4, "bad ERROR pkt size of " + buf.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(buf, 0, buf.length);
            DataInputStream dis = new DataInputStream(bais);
            try {
                byte p = dis.readByte();
                byte o = dis.readByte();
                this._errcode = dis.readShort();
            }
            catch (IOException ioe) {
                System.err.println("DATA packet conversion failed");
                return;
            }
        }

        public int size() {
            return super.size() + 2;
        }
    }
}

