
#include <iostream>
#include <string>
#include <stdio.h>
#include <stdlib.h>

// may need g++ -std=c++0x ratio.cpp

using namespace std;

class Ratio {
private:
	int numerator;
	int denominator;
public:
	Ratio(int num, int denom) {
	// pre: denom != 0
		numerator = num;
		denominator = denom;
		reduce();
	}

	int getNumerator() {
		return numerator;
	}

	int getDenominator() {
		return denominator;
	}

	double getValue() {
		return (double)numerator/(double)denominator;
	}

	Ratio add(Ratio other) {
		int newnum = numerator*other.denominator + denominator*other.numerator;
		int newdenom = denominator*other.denominator;
		return Ratio(newnum, newdenom);
	}

private:
	void reduce() {
		int divisor = gcd(numerator, denominator);
		if (denominator < 0) divisor = -divisor;
		numerator = numerator / divisor;
		denominator = denominator / divisor;
	}

	// recursive version
	static int rgcd(int a, int b) {
		if (a<0) return gcd(-a, b);
		if (a==0) {
		    if (b==0) return 1;
		    return b;
		}
		if (b<a) return rgcd(b,a);
		return rgcd(b%a, a);
	}

	// non-recursive version
	static int gcd(int a, int b) {
	    while (a>0 && b>0) {
       		if (a>=b) a = a % b;
       		else b = b % a;
    	    }
    	    if (a==0) return b; else return a;
	}

	string myitoa(int n) {
		char buf[12];
		//itoa(n, buf, 10);
		snprintf(buf, sizeof(buf), "%d", n);
		return string(buf);
	}

public:
	string ToString() {
		return string("") + myitoa(numerator) + "/" + myitoa(denominator);
		// to compile the following you need: g++ -std=c++0x ratio.cpp
		//return string("") + to_string(numerator) + "/" + to_string(denominator);
	}
};	// pld: note semicolon

ostream & operator<< (ostream & o, Ratio & i) {		// should really be "const Ratio", but ...
	return o << i.ToString();
}
	
int main(int argc, char** argv) {
	Ratio r1(3,5);				// no "new"
	Ratio r2 = Ratio(2,5);			// alternative syntax
	Ratio r3(1,3);
	Ratio r4 = r1.add(r3);
	Ratio* rp = new Ratio(1,4);		// heap allocation
	cout << r1.ToString() << endl;
	cout << r2.ToString() << endl;
	cout << r3.ToString() << endl;
	cout << r4.ToString() << endl;
	cout << r2.add(r1).ToString() << endl;
	cout << r3.add(Ratio(1,6)).ToString() << endl;		// no "new"
	cout << "now for without ToString" << endl;
	/* */
	cout << r1 << endl;
	cout << r2 << endl;
	/* */
}



