/**
 * Class StrList represents a list of Strings; it is our own version
 * of ArrayList<String>.
 * You create the list entries by using Add(), one at a time.
 * Once you have a list, you can print it.
 *
 * You can get the nth value with get(n), or set the nth value with set(n, val).
 * If n is out of range, get(n) returns 0 and set(n, val) does nothing.
 *
 */


class StrList {
    // instance variables - replace the example below with your own
    private String[] elements;
    private int currsize;

    /**
     * Constructor for objects of class StrList
     */
    public StrList()
    {
        // initialise instance variables
        final int defaultCapacity = 5;
        currsize = 0;
        elements = new String[defaultCapacity];
    }

    /**
     * parameter constructor, allowing you to predefine a capacity.
     */
    public StrList(int capacity) {
        currsize = 0;
        elements = new String[capacity];
    }

    /**
     * Add() Adds the value y to the list, at position currsize
     * (that is, at the end of the existing list).
     * The size of the list is incremented.
     * If pos = nums.length, there is no more room, so this version doesn't do anything;
     * THAT PART YOU ARE TO FIX!!
     */
    public void add(String y) {
        if (currsize == elements.length) {
            System.out.println("no more room to add " + y);     // fix this to increase space instead!
            return;
        }
        elements[currsize] = y;
        currsize += 1;      // or currsize++
    }

    // get nth value, with range check
    public String get(int n) {
        if (n<0 || n >= currsize) {
            System.out.println("Warning: StrList.get() called with out-of-range n = " + n);
            return null;
        }
        return elements[n];
    }

    // set nth value, with range check
    public void set(int n, String val) {
        if (n<0 || n >= currsize) {
            System.out.println("Warning: Strlist.set() called with out-of-range n = " + n);
            return;
        }
        elements[n] = val;
    }

    public int size() {
        return currsize;
    }


    public void print() {
        int i=0;
        while (i<currsize) {
            System.out.println(i + ":  " + elements[i]);
            i++;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) return false;

        // If parameter cannot be cast to StrList return false.
        if (! (obj instanceof StrList)) return false;
        StrList s2 = (StrList) obj;	// downcast

        // now we check the actual data:
        if (currsize != s2.currsize) return false;
        for (int i=0; i< currsize; i++) {
            if (!(elements[i].equals(s2.elements[i]))) return false;
            //if (!(elements[i]==s2.elements[i])) return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        for (int i = 0; i< currsize; i++) {
            hc = hc ^ elements[i].hashCode();
        }
        return hc;
    }
}
