//answer-cache version of Fibonacci

class Fibonacci2 {

    static int callcount;
    static long [] answercache;

    public static void main(String[] args) {
    int N = 10;
    if (args.length > 0) {
        N = new Integer(args[0]);
        System.out.println( "N is" + N);
    }
    long starttime = System.currentTimeMillis();
    System.out.println(fibonacci(N));
    System.out.format("time: %d milliseconds", System.currentTimeMillis() - starttime);
    System.out.println("number of calls: " + callcount);
    }

    public static long fibonacci(int N) {
    answercache = new long[N+1];
    for (int i = 0; i<N; i++) answercache[i] = 0;
    return rfibonacci(N);
    }

    public static long rfibonacci(int N) {
    callcount++;
    if (N<=1) return 1;
    if (answercache[N] != 0) return answercache[N];
    long res = rfibonacci(N-2) + rfibonacci(N-1);
    answercache[N] = res;
    return res;
    }

    // from https://paulhankin.github.io/Fibonacci/
    public static long phfibonacci(long n) {
    return (4 << n*(3+n)) / ((4 << 2*n) - (2 << n) - 1) & ((2 << n) - 1);
    }

}