

class Factorial {

    public static void main(String[] args) {
    int N = 10;
    if (args.length > 0) {
        N = new Integer(args[0]);
        System.out.format("N is %d%n", N);
    }
        System.out.println(factorial1(N));
    }

    // classic factorial
    public static int factorial1(int N) {
        System.out.format("calling factorial(%d)%n", N);
        if (N==1) return 1;
        return N*factorial1(N-1);
    }

    // factorial returning 1 for all N<=1
    public static long factorial2(int N) {
    //System.out.format("calling factorial(%d)%n", N);
    if (N<=1) return 1;     // safer ???
    return N*factorial2(N-1);
    }

    // factorial that prints its argument and return value
    public static long factorial3(int N) {
        System.out.println("factorial3 called with N="+ N);
        long retval;
        if (N==1) retval = 1;
        else {
        /*A*/ long fact =  factorial3(N-1);
            retval = N * fact;
        }
        System.out.format("factorial3(%d) returns %d%n", N, retval);
        return retval;
    }


    // tail-recursive version of factorial
    public static long tr_factorial(int n, long prod) {
        if (n==0) return prod;
        return tr_factorial(n-1, n*prod);
    }

    // caller of tail-recursive version
    public static long factorial4(int n) {
    return tr_factorial(n,1);
    }

}