

class Fibonacci {

    static long callcount;

    public static void main(String[] args) {
    int N = 10;
    Fibonacci.callcount = 0;
    if (args.length > 0) {
        N = new Integer(args[0]);
        System.out.println("N is " + N);
    }
    long starttime = System.currentTimeMillis();
    System.out.println(fibonacci1(N));

    System.out.format("time: %d milliseconds", System.currentTimeMillis() - starttime);
    System.out.println("number of calls: " + Fibonacci.callcount);
    }

    public static long fibonacci1(int N) {
    callcount++;
    //System.out.println("called fibonacci1({0})", N);
    if (N<=1) return 1;
    return fibonacci1(N-2) + fibonacci1(N-1);
    }

    public static long ifibonacci(int N) {
        long F = 1;
    long prev=1;
    while (N>1) {
        N --;
        long temp = F;
        F = F + prev;
        prev = temp;
    }
    return F;
    }

    public static class longpair {
    long first, second;
    public longpair(long f, long s) {first = f; second = s;}
    public long getfirst()  {return first;}
    public long getsecond() {return second;}
    }

    public static long fibonacci2(int N) {
    longpair res = fib2(N);
    return res.getfirst();
    }

    public static longpair fib2(int N) {
    if (N==1) return new longpair(1,1);
    longpair res = fib2(N-1);
    return new longpair(res.getfirst()+res.getsecond(), res.getfirst());
    }

    public static long fibonacci3(int N) {
    System.out.format("fibonacci3 called with N=%d%n", N);
    long retval;
    if (N<=1) retval = 1;
    else retval =  fibonacci3(N-2) + fibonacci3(N-1);
    System.out.format("fibonacci3(%d) returns %d%n", N, retval);
    return retval;
    }

    private static long[] answer_cache;

    public static long fibonacci4(int N) {
        answer_cache = new long[N+1];
        return rfibonacci(N);
    }

    private static long rfibonacci(int N) {
        if (N<=1) return 1;
        if (answer_cache[N] != 0) {
            // what do you return here?
        }
        long res = rfibonacci(N-2) + rfibonacci(N-1);   // usual calculation
        // how do you update answer_cache?
        return res;
    }
        
    // from https://paulhankin.github.io/Fibonacci/
    // works up to n=6
    public static long phfibonacci(int n) {
    return (((long) 4) << n*(3+n)) 
     / ((((long) 4) << 2*n) - (((long) 2) << n) - 1)
     & ((((long) 2) << n) - 1);
    }
}