import java.util.Iterator;

/**
 * Sorted Linked List.
 * 
 * @author (your name) 
 * @version (a version number or a date)
 */
public class SortedList<T extends Comparable<T> >
{

    /**
     * Constructor for objects of class LinkedList
     */
    static class Cell<T> {
       private T data;
       private Cell<T> next;
       Cell(T s, Cell<T> n) {data = s; next = n;}
       T data() {return this.data;}
       Cell<T> next() {return this.next;}
       void setData(T s) {data = s;}
       void setNext(Cell<T> c)   {next = c;}
    }

    private Cell<T> head;
    private int count;
    
    public SortedList() {head = null; count = 0;}
     
    public void printList() {
        Cell<T> p = head;
        while (p!=null) {
            System.out.println(p.data());
            p = p.next();
        }
        count++;
    }
        
    
    public int size() {
        return count;
    }
    
    public T get(int n) {
        Cell<T> p = head;
        if (n>=count) return null;
        while (n>0) {
            p = p.next();
            n--;
        }
        return p.data();
    }
        

    /*# you are to implement verifySorted() */
    
    public boolean verifySorted() {
        Cell<T> p = head;
        Cell<T> prev = head;
        
        return false;
    }

    
   
    /*#
     * the following inserts val before the first cell for which val < data,
     * or at the end.
     * You implement this!
     */
    public void add(T value) {
    }
    
    /**
     * remove the first cell matching the specified element
     * We return true if it was there, false otherwise
     * Again, we have to consider removing the first value separately!
     */
    public boolean remove(T value) {
        if (head == null) {
            return false;
        }
        // check first element
        if (head.data().equals(value)) {
            head = head.next();
            return true;
        }
        /*# now begin with second element (first one pointed to by a previous cell) */
        Cell<T> p = head.next();
        Cell<T> prev = head;
        while (p!= null && !p.data().equals(value)) {
            prev = p;
            p = p.next();
        }
        if (p==null) return false;  // not there
        prev.setNext(p.next());
        
        return true;
    }
}
