import java.util.ArrayList;
import java.util.Iterator;

/**
 * Write a description of class Matrix here.
 * 
 * @author Peter Dordal
 * @version 0.9
 */
public class Matrix<E>
{
    // instance variables - replace the example below with your own
    int rowcount = 0;
    int colcount = 0;
    ArrayList<ArrayList<E> > rows;
    
    /**
     * Constructor for objects of class Matrix, 
     * with r rows and c columns
     */
    public Matrix(int r, int c)
    {
        // initialise instance variables
        rowcount = r;
        colcount = c;
        rows = new ArrayList<ArrayList<E> >(rowcount);
        for (int i = 0; i<rowcount; i++) {
            ArrayList<E> theRow = new ArrayList<E>(colcount);
            for (int j=0; j<colcount; j++) {
                theRow.add(null);   // fill in row
            }
            rows.add(theRow);   // add the row to the matrix
        }
    }

    public int width() {return colcount;}   //  width = # of columns
    public int height(){return rowcount;}
    
    /**
     * get(i,j): retrieves the element at row i, col j
     */
    public E get(int i, int j)  {
        if (i<0 || i>=rowcount) {
            System.out.println("get(): row number " + i + " is outside the range " 
                + 0 + ".." + (rowcount));
            return null;
        }
         if (j<0 || j>=colcount) {
            System.out.println("get(): column number " + j + " is outside the range "
                + 0 + ".." + (colcount));
            return null;
        }
        
        return (rows.get(i)).get(j);    // get jth col of ith row
    }
    
    /**
     * set(i,j,val): usual set method; this time it *does* return the old value
     */
    public E set(int i, int j, E newval)  {
        if (i<0 || i>=rowcount) {
            System.out.println("set(): row number " + i + " is outside the range " 
                + 0 + ".." + (rowcount));
            return null;
        }
         if (j<0 || j>=colcount) {
            System.out.println("set(): column number " + j + " is outside the range "
                + 0 + ".." + (colcount));
            return null;
        }
        
        E oldval = get(i,j);
        
        ArrayList<E> theRow = rows.get(i);    // retrieve reference to entire row
        theRow.set(j,newval);
        
        return oldval;
    }
    
    /*#
     * #1: addRow(). YOU DO THIS ONE
     * Adds a row of nulls, of width colcount
     */
    public void addRow() {
    }
    
    /*#
     * #2: addColumn().  YOU DO THIS ONE
     * Adds a column of nulls, one null at the end of each row
     */
    public void addColumn() {
    }
    
    /*#
     * #3: rowList(): 
     * returns all rowcount*colcount entries in a long ArrayList<E>
     */
    public ArrayList<E> rowList() {
        ArrayList<E> result = new ArrayList<E>();
        /*# your stuff goes here */
        return result;
    }
    
    
    /**
     * Prints the matrix, in tabular form as best it can.
     * In this version the fields are aligned at the right.
     */
    public void print(int fwidth) {
        for (int r = 0; r<rowcount; r++) {
            for (int c=0; c<colcount; c++) {
                String s = get(r,c).toString();
                int spacecount, datawidth=fwidth-1;
                if (s.length() < datawidth) datawidth=s.length();
                s = s.substring(0,datawidth);    // clip to field width
                spacecount = fwidth-datawidth;
                for (int i=0;i<spacecount;i++) System.out.print(' ');
                System.out.print(s);
            }
            System.out.println();
        }
    }

    public Iterator<E> rowIterator() {
        return new MyRowIterator<E>(this);
    }

    public Iterator<E> colIterator() {     /*# nothing to do here, but see below */
        return new MyColIterator<E>(this);
    }
    
    /* */    
    
    private class MyRowIterator<E> implements Iterator<E>
    {
        private int theRow;      // row of next element to be returned
        private int theCol;     // col of next element to be returned
        private Matrix<E> M;
        //
        // Constructor for objects of class MyIterator
        //
        public MyRowIterator(Matrix<E> M)
        {
            // initialise instance variables
            theRow = 0;
            theCol = 0;
            this.M = M;
        }
    
        public boolean hasNext() {
            return theRow < M.height();
        }
        
        public E next() {
            E theElt = M.get(theRow, theCol);
            theCol++;
            if (theCol >= M.width()){   // start new row
                theRow++;
                theCol = 0;
            }
            return theElt;
        }
        
        public void remove() {}  // does nothing
    }

    /*# #4: Finish this private class so that colIterator() will work */
    private class MyColIterator<E> implements Iterator<E>
    {
        private int theRow;      // row of next element to be returned
        private int theCol;     // col of next element to be returned
        private Matrix<E> M;
        //
        // Constructor for objects of class MyIterator
        //
        public MyColIterator(Matrix<E> M)
        {
            /*# maybe change this, maybe not */
            theRow = 0;
            theCol = 0;
            this.M = M;
        }
    
        public boolean hasNext() {
            return false;       /*# fix this!! */
        }
        
        public E next() {
            return null;        /*# fix this!! */
        }

        public void remove() {}     // does nothing
    }

    
}
